<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class FTc_Instagram extends Widget_Base {

	public function get_name() {
		return 'ftc-instagram';
	}

	public function get_title() {
		return __( 'FTC - Instagram Feed', 'themeftc-core' );
	}

	public function get_icon() {
		return 'ftc-icon';
	}

	public function get_categories() {
		return [ 'ftc-elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Instagram settings', 'themeftc-core' ),   //section name for controler view
			]
		);
		$this->add_control(
			'def_style',
			[
				'label' => esc_html__( 'Apply style default', 'themeftc-core' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'yes' => __( 'Yes', 'themeftc-core' ),
					'no' => __( 'No', 'themeftc-core' ),
				],
				'default' => 'no',
			]
		);
		$this->add_control(
			'def_style_option',
			[
				'label' => __( 'Default style', 'themeftc-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'def_style_1',
				'options' => [
					'def_style_1' => __( 'Style 1', 'themeftc-core' ),
					'def_style_2' => __( 'Style 2', 'themeftc-core' ),
					'def_style_3' => __( 'Style 3', 'themeftc-core' ),
					'def_style_4' => __( 'Style 4', 'themeftc-core' ),
					'def_style_5' => __( 'Style 5', 'themeftc-core' ),
					'def_style_6' => __( 'Style 6', 'themeftc-core' ),
					'def_style_7' => __( 'Style 7', 'themeftc-core' )
				],
				'condition' => ['def_style' => 'yes'],
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title : ', 'themeftc-core' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => 'Instagram',
				'label_block' => true,
			]
		);
		$this->add_responsive_control(
			'post_title_align',
			[
				'label'     => __( 'Post text alignment', 'themeftc-core' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'left'   => [
						'title' => __( 'Left', 'themeftc-core' ),
						'icon'  => 'eicon-h-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'themeftc-core' ),
						'icon'  => 'eicon-h-align-center',
					],
					'right'  => [
						'title' => __( 'Right', 'themeftc-core' ),
						'icon'  => 'eicon-h-align-right',
					],
				],
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .ftc-element-instagram h2' => 'text-align: {{VALUE}};',
				],

			]
		);
		$this->add_control(
			'margin_title',
			[
				'label'      => esc_html__( 'Margin Title', 'themeftc-core' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}}  .ftc-element-instagram h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'username_hashtag',
			[
				'label'       => __( 'Username or #tag : ', 'themeftc-core' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Example: @themeftc', 'themeftc-core' ),
				'default'     => '',
				'label_block' => true,
			]
		);
		$this->add_control(
			'photos_number',
			[
				'label'       => __( 'Number of images displayed ', 'themeftc-core' ),
				'type'        => Controls_Manager::NUMBER,
				'default'     => 5,
				'max'         => 30,
				'min'         => 1,
				'label_block' => true,
			]
		);
		$this->add_control(
			'columns',
			[
				'label'   => __( 'Number of columns', 'themeftc-core' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '5',
				'options' => [
					'1' => __( '1', 'themeftc-core' ),
					'2' => __( '2', 'themeftc-core' ),
					'3' => __( '3', 'themeftc-core' ),
					'4' => __( '4', 'themeftc-core' ),
					'5' => __( '5', 'themeftc-core' ),
					'6' => __( '6', 'themeftc-core' ),
					'7' => __( '7', 'themeftc-core' ),
					'8' => __( '8', 'themeftc-core' ),
				],
				'selectors'  => [
					'{{WRAPPER}}  .ftc-instagram-feed-gallery-widget-image-wrapper ul' => '--columns: {{VALUE}};',
				],
				'condition' => [
					'is_slider!'  => 'yes'
				]
			]
		);
		$this->add_control(
			'columns_slider',
			[
				'label'   => __( 'Number of columns', 'themeftc-core' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '5',
				'options' => [
					'1' => __( '1', 'themeftc-core' ),
					'2' => __( '2', 'themeftc-core' ),
					'3' => __( '3', 'themeftc-core' ),
					'4' => __( '4', 'themeftc-core' ),
					'5' => __( '5', 'themeftc-core' ),
					'6' => __( '6', 'themeftc-core' ),
					'7' => __( '7', 'themeftc-core' ),
					'8' => __( '8', 'themeftc-core' ),
				],
				'condition' => [
					'is_slider'  => 'yes'
				]
			]
		);
		$this->add_control(
			'aspect_ratio',
			[
				'label'     => __( 'Ratio Image', 'themeftc-core' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => '1/1',
				'options'   => [
					'1/1'     => __( '1:1', 'themeftc-core' ),
					'3/2'     => __( '3:2', 'themeftc-core' ),
					'4/3'     => __( '4:3', 'themeftc-core' ),
					'16/9'    => __( '16:9', 'themeftc-core' ),
					'16/10'   => __( '16:10', 'themeftc-core' ),
					'5/4'     => __( '5:4', 'themeftc-core' ),
					'inherit' => __('Auto', 'themeftc-core')
				],
				'selectors'  => [
					'{{WRAPPER}}  .ftc-instagram-feed-gallery-widget-image-wrapper ul' => '--ratio: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'photo_space_grid',
			[
				'label'   => __( 'Space item', 'themeftc-core' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 10,
				'min'     => 0,
				'max'     => 100,
				'title'   => __( 'Space between items', 'themeftc-core' ),
				'selectors'  => [
					'{{WRAPPER}}  .ftc-instagram-feed-gallery-widget-image-wrapper ul' => '--gap: {{VALUE}}px;',
				],
				'condition' => [
					'is_slider!'  => 'yes'
				]
			]
		);
		$this->add_control(
			'photo_space',
			[
				'label'   => __( 'Space item slider', 'themeftc-core' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 10,
				'min'     => 0,
				'max'     => 100,
				'title'   => __( 'Space between items', 'themeftc-core' ),
				'condition' => [
					'is_slider'  => 'yes'
				]
			]
		);
		// $this->add_control(
		// 	'container_size',
		// 	[
		// 		'label'     => __( 'Width Container Section', 'themeftc-core' ),
		// 		'type'      => Controls_Manager::NUMBER,
		// 		'default'   =>  300,
		// 		]
		// );

		$this->add_control(
			'link_text',
			[
				'label'       => __( 'Label button Follow : ', 'themeftc-core' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Example: Follow...', 'themeftc-core' ),
				'default'     => 'Follow Instagram',
				'label_block' => true,
			]
		);
		$this->add_responsive_control(
			'post_label_align',
			[
				'label'     => __( 'Position button alignment', 'themeftc-core' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'left'   => [
						'title' => __( 'Left', 'themeftc-core' ),
						'icon'  => 'eicon-h-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'themeftc-core' ),
						'icon'  => 'eicon-h-align-center',
					],
					'right'  => [
						'title' => __( 'Right', 'themeftc-core' ),
						'icon'  => 'eicon-h-align-right',
					],
				],
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .instagram-button' => 'text-align: {{VALUE}};',
				],

			]
		);
		$this->add_control(
			'back_color',
			[
				'label'     => __( 'Background color button', 'themeftc-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .instagram-button a' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'btn_color',
			[
				'label'     => __( 'Color button', 'themeftc-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .instagram-button a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'btn-padding',
			[
				'label'      => esc_html__( 'Button Padding', 'themeftc-core' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'default'    => [
					'top' => '10',
					'right' => '15',
					'bottom' => '10',
					'left' => '15',
					'unit' => 'px',
				],
				'selectors'  => [
					'{{WRAPPER}} .instagram-button a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'hover_animation',
			[
				'label' => __( 'Hover animation', 'themeftc-core' ),
				'type'  => Controls_Manager::HOVER_ANIMATION,
			]
		);
		$this->add_control(
			'is_slider',
			[
				'label'           => __( 'Display in Slider', 'themeftc-core' ),
				'type'            => Controls_Manager::SWITCHER,
				'default'         => 'no',
				'label_on'        => __( 'Yes', 'themeftc-core' ),
				'label_off'       => __( 'No', 'themeftc-core' ),
			]
		);
		$this->add_control(
			'show_nav',
			[
				'label'           => __( 'Show navigation', 'themeftc-core' ),
				'type'            => Controls_Manager::SWITCHER,
				'default'         => 'yes',
				'label_on'        => __( 'Yes', 'themeftc-core' ),
				'label_off'       => __( 'No', 'themeftc-core' ),
			]
		);
		$this->add_control(
			'auto_play',
			[
				'label'           => __( 'Auto play', 'themeftc-core' ),
				'type'            => Controls_Manager::SWITCHER,
				'default'         => 'yes',
				'label_on'        => __( 'yes', 'themeftc-core' ),
				'label_off'       => __( 'No', 'themeftc-core' ),
			]
		);


		$this->end_controls_section();
	}

	protected function render() {

		$settings           = $this->get_settings();
		$title              = $settings['title'];
		$username_hashtag   = $settings['username_hashtag'];
		$photos_number      = $settings['photos_number'];
		$columns            = $settings['columns'];
		$columns_slider     = $settings['columns_slider'];
		$photo_space          = $settings['photo_space'];
		// $container_size             = $settings['container_size'];
		$link_text            = $settings['link_text'];
		$def_style             = $settings['def_style'];
		$def_style_option      = $settings['def_style_option'];
		$hover_animation    = $settings['hover_animation'];
		$is_slider    = $settings['is_slider'];
		$auto_play    = $settings['auto_play'];
		$show_nav   = $settings['show_nav'];

		if($def_style == 'yes'){
			$def_style_optionn = $def_style_option;
		}
		else{
			$def_style_optionn = '';
		}

		$column_target = ($is_slider === 'yes') ? $columns_slider : $columns;
		?>
		<div class="ftc-element-instagram <?php echo $def_style_optionn; ?>" >
			<?php
			// echo do_shortcode('[ftc_insta_photo_feed title="'.$title.'" username="'.$username_hashtag .'" container_size="1920" columns="'.$columns.'" photo_space="'.$photo_space.'" photos_number="'.$photos_number.'" link_text="'.$link_text.'" hover_animation="'.$hover_animation.'" is_slider="'.$is_slider.'" auto_play="'.$auto_play.'" show_nav="'.$show_nav.'"]');
			echo do_shortcode('[ftc-instagram-feed-gallery-widget title="'.$title.'" element="shortcode" photos_number="'.$photos_number.'" link_text="'.$link_text.'" columns="'.$column_target.'" is_slider="'.$is_slider.'" auto_play="'.$auto_play.'" show_nav="'.$show_nav.'" photo_space="'.$photo_space.'"]');
			?>
		</div>
		<?php

if(is_admin()){
	?>
	<script type="text/javascript">
		(function ($) {
			"use strict";
			$('.ftc-instagram-feed-gallery-widget-image-wrapper ul.owl-carousel').each(function () {
    var element = $(this);
    var columns = element.data('columns') && parseInt(element.data('columns')) || 5;
    var show_nav = element.data('show_nav') && element.data('show_nav') === 'yes' ? true : false;
    var auto_play = element.data('autoplay') && element.data('autoplay') === 'yes' ? true : false;
    var margin = element.data('gap') && parseInt(element.data('gap')) || 10;
    $(this).owlCarousel({
      loop: true
      ,nav: show_nav
      ,dots: false
      ,navText: [,]
      ,navSpeed: 1000
      ,slideBy: 1
      ,rtl: $('body').hasClass('rtl')
      ,margin: margin
      ,navRewind: false
      ,autoplay: auto_play
      ,autoplayTimeout: 5000
      ,autoplayHoverPause: true
      ,autoplaySpeed: 1000
      ,autoHeight: true
      ,responsive: {
        0:{
          items: 2
        },
        480:{
          items: 2
        },
        700:{
          items: 3
        },
        768:{
          items: columns
        },
        991:{
          items: columns
        },
        1199:{
          items:columns
        }
      }
      ,onInitialized: function(){
        element.addClass('loaded').removeClass('loading');
      }

    });

  });
		})(jQuery);
			</script>
			<?php
	}
}

}

Plugin::instance()->widgets_manager->register( new FTc_Instagram() );
