<?php
/**
 *
 * @package WordPress
 * @subpackage ThemeFTC Elements
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * FTC Elements Class
 */
class FTC_Elements {

	/**
	 * This Class instance
	 *
	 * @var object
	 */
	private static $instance = null;

	/**
	 * Get instance
	 *
	 * @return $instance
	 */
	public static function get_instance() {
		if ( ! self::$instance ) {
			self::$instance = new self;
		}
		return self::$instance;
	}

	/**
	 * Initialize plugin
	 *
	 * @return void
	 */
	public function init() {

		if ( self::$instance->elementor_activation_check() ) {

			self::$instance->includes();

			// Add " Elements" widget categories.
			add_action( 'elementor/elements/categories_registered', array( $this, 'add_widget_categories' ) );

			// Register "elements" widgets.
			add_action( 'elementor/widgets/register', array( $this, 'widgets_registered' ) );

			// Add custom controls to Elementor section.
			add_action( 'elementor/element/after_section_end', [ $this, 'custom_section_controls' ], 10, 5 );
			add_action( 'elementor/controls/register', [ $this, 'register_controls' ] );

			// Load textdomain.
			add_action( 'plugins_loaded', array( self::$instance, 'load_plugin_textdomain' ) );

			// Check for plugin dependecies.
			add_action( 'plugins_loaded', array( self::$instance, 'plugins_dependency_checks' ) );

			// Register CPT's
			add_action( 'init', array( self::$instance, 'register_cpts' ) );

			// Enqueue script and styles for Elementor editor.
			add_action( 'elementor/editor/before_enqueue_scripts', array( self::$instance, 'editor_scripts' ), 999 );
			// add_action( 'elementor/editor/before_enqueue_scripts', array( self::$instance, 'ftc_elements_admin_js',998 ) );

			// Enqueue scripts and styles for frontend.
			add_action( 'wp_enqueue_scripts', array( self::$instance, 'ftc_elements_styles' ) );
			add_action( 'wp_enqueue_scripts', array( self::$instance, 'ftc_elements_scripts' ) );
			
		} else {

			add_action( 'admin_notices', array( self::$instance, 'admin_notice' ) );
		}

	}
	private function __construct() {
		$this->add_actions();
		$this->include_files();
		$this->ftc_removeDemoModeLink();
		$this->remove_some_scripts_on_demo();

		if (!is_admin() && !defined('DOING_AJAX') && isset($_GET['color'])) {
			add_action('wp_enqueue_scripts', array($this, 'add_inline_custom_style'), 1000000);
		}

		/* Remove some scripts, styles from demo */
		add_action('wp_enqueue_scripts', array($this, 'remove_some_scripts_on_demo'), 10000);

		/* remove emoji */
		remove_action('wp_head', 'print_emoji_detection_script', 7);
		remove_action('wp_print_styles', 'print_emoji_styles');
		
	}
	protected function add_actions() {
		add_action( 'elementor/editor/after_enqueue_styles', [ $this, 'enqueue_editor_styles' ] );
	}

	protected function include_files(){
		$file_names = array('banner', 'brands_slider', 'footer', 'product_deals', 'single_image', 'testimonial','blogs','blogs_tabs','product_categories','product_filter_by_color','products','recent_comments','feedburner_subscription');
		foreach ($file_names as $file_name) {
			$file = FTC_CORE_DIR . '/includes/' . $file_name . '.php';
			if (file_exists($file)) {
				require($file);
			}
		}
		require FTC_CORE_DIR  . '/redirect.php';
		require FTC_CORE_DIR . '/meta_boxes.php';
		require FTC_CORE_DIR . '/shortcode/register.php';
		require FTC_CORE_DIR . '/shortcode/shortcodes.php';
	}

	protected function ftc_removeDemoModeLink(){ // Be sure to rename this function to something more unique
		if (class_exists('ReduxFrameworkPlugin')) {
			remove_filter('plugin_row_meta', array(ReduxFrameworkPlugin::get_instance(), 'plugin_metalinks'), null, 2);
		}
		if (class_exists('ReduxFrameworkPlugin')) {
			remove_action('admin_notices', array(ReduxFrameworkPlugin::get_instance(), 'admin_notices'));
		}
	}

	function add_inline_custom_style(){
		$custom_file = get_template_directory() . '/inc/dynamic_style.php';
		if (file_exists($custom_file)) {
			wp_dequeue_style('ftc-dynamic-css');

			ob_start();
			include $custom_file;
			$custom_css = ob_get_clean();

			wp_add_inline_style('ftc-style', $custom_css);
		}
	}

	function remove_some_scripts_on_demo()
	{
		global $post;
		add_action('wp_enqueue_scripts', function () {
			wp_deregister_script('vc_tta_autoplay_script');
			wp_dequeue_style('jquery-selectBox');
		});
		if (isset($post->post_content) && !has_shortcode($post->post_content, 'contact-form-7')) {
			add_action('wp_enqueue_scripts', function () {
				wp_dequeue_script('jquery-form');
				wp_dequeue_script('contact-form-7');
				wp_dequeue_style('contact-form-7');
			});
		}
	}

    /**
	 * Enqueue editor styles
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
    public function enqueue_editor_styles() {

    	wp_enqueue_style(
    		'ftc-elements-font',
    		FTC_CORE_URL . 'assets/css/back.css',
    		[],
    		''
    	);
    }


	/**
	 * Define constant if not already set.
	 *
	 * @param string      $name  Constant name.
	 * @param string|bool $value Constant value.
	 */
	private function define( $name, $value ) {
		if ( ! defined( $name ) ) {
			define( $name, $value );
		}
	}

	/**
		 * Defines all constants
		 *
		 */
	/**
	 * Register custom post types
	 *
	 * @return false
	 */
	public function register_cpts() {

		if ( current_theme_supports( 'ftc-elements-cpt' ) && ELEMENTOR_IS_ACTIVE ) {

			// include file with Custom Post Types registration
			// MM Mega Menu, MM Header, MM Footer.
			require FTC_CORE_DIR . '/includes/core/cpt.php';

		}

		return false;

	}

	/**
	 * Check for Elementor activation
	 *
	 * @return $elements_is_active
	 */
	private function elementor_activation_check() {

		$ftc_elements_is_active = false;

		//if ( defined( 'ELEMENTOR_PATH' ) && class_exists( 'Elementor\Widget_Base' ) ) {
		if ( in_array( 'elementor/elementor.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ), true ) ) {

			$ftc_elements_is_active = true;
			$this->define( 'ELEMENTOR_IS_ACTIVE', true );
		} else {
			$this->define( 'ELEMENTOR_IS_ACTIVE', false );
		}

		return $ftc_elements_is_active;

	}

	/**
	 * Activation checks for various plugins (dependencies)
	 *
	 * @return void
	 */
	public function plugins_dependency_checks() {
		// VARIOUS PLUGINS ACTIVATION CHECKS.
		require_once FTC_CORE_DIR . 'includes/active-plugins.php';

	}

	/**
	 * Register categories for widgets (elements)
	 * 
	 * @return void
	 */
	public function add_widget_categories() {

		$elements_manager = Elementor\Plugin::instance()->elements_manager;
		$elements_manager->add_category(
			'ftc-elements',
			[
				'title' => __( 'ThemeFTC Elements', 'themeftc-core' ),
				'icon'  => 'eicon-font',
			],
			1
		);
		$elements_manager->add_category(
			'ftc-elements-header',
			[
				'title' => __( 'ThemeFTC Header Content ', 'themeftc-core' ),
				'icon'  => 'eicon-font',
			],
			1
		);
	}

	/**
	 * Register widgets (elements) for Elementor
	 *
	 * @return void
	 */
	public function widgets_registered() {

		require_once FTC_CORE_DIR . 'widgets/ftc-blogs-grid.php';
		require_once FTC_CORE_DIR . 'widgets/ftc-blogs-slider.php';
		require_once FTC_CORE_DIR . 'widgets/ftc-blogs-timeline.php';
		require_once FTC_CORE_DIR . 'widgets/ftc-buttons.php';
		require_once FTC_CORE_DIR . 'widgets/ftc-single-image.php';
		require_once FTC_CORE_DIR . 'widgets/ftc-product-deal-slider.php';
		// require_once FTC_CORE_DIR . 'widgets/ftc-countdown-timer.php';
		require_once FTC_CORE_DIR . 'widgets/circle-countdown.php';
		require_once FTC_CORE_DIR . 'widgets/countdown.php';
		require_once FTC_CORE_DIR . 'widgets/ftc-products-tabs-grid.php';
		require_once FTC_CORE_DIR . 'widgets/ftc-portfolios.php';
		require_once FTC_CORE_DIR . 'widgets/ftc-testimonial.php';
		require_once FTC_CORE_DIR . 'widgets/ftc-facebook.php';
		require_once FTC_CORE_DIR . 'widgets/ftc-hotspot.php';
		require_once FTC_CORE_DIR . 'widgets/ftc-team-member.php';
		require_once FTC_CORE_DIR . 'widgets/ftc-brand.php';
		require_once FTC_CORE_DIR . 'widgets/ftc-footer.php';

		require_once FTC_CORE_DIR . 'widgets/ftc-360-rotation.php';
		require_once FTC_CORE_DIR . 'widgets/ftc-accordion-image.php';
		require_once FTC_CORE_DIR . 'widgets/ftc-custom-popup.php';
		require_once FTC_CORE_DIR . 'widgets/ftc-custom-timeline.php';
		require_once FTC_CORE_DIR . 'widgets/ftc-dropcap.php';
		require_once FTC_CORE_DIR . 'widgets/ftc-dual-heading.php';
		require_once FTC_CORE_DIR . 'widgets/ftc-flip-box.php';
		require_once FTC_CORE_DIR . 'widgets/ftc-price-list.php';
		require_once FTC_CORE_DIR . 'widgets/ftc-price-table.php';
		require_once FTC_CORE_DIR . 'widgets/header/ftc-logo.php';
		require_once FTC_CORE_DIR . 'widgets/header/shopping-cart.php';
		require_once FTC_CORE_DIR . 'widgets/header/wishlist.php';
		require_once FTC_CORE_DIR . 'widgets/header/my-account.php';
		require_once FTC_CORE_DIR . 'widgets/header/dropdown.php';
		require_once FTC_CORE_DIR . 'widgets/header/checkout.php';
		require_once FTC_CORE_DIR . 'widgets/header/search.php';
		require_once FTC_CORE_DIR . 'widgets/header/menu-vertical.php';
		require_once FTC_CORE_DIR . 'widgets/header/language-switch.php';
		require_once FTC_CORE_DIR . 'widgets/header/currency-switch.php';



		// require_once FTC_CORE_DIR . 'widgets/header/ftc-logo.php';
		// require_once FTC_CORE_DIR . 'widgets/header/shopping-cart.php';


		// Revolution Slider plugin element.
		if ( FTC_REVSLIDER_ACTIVE ) {
			require_once FTC_CORE_DIR . 'widgets/ftc-revolution-slider.php';
		}
		// WooCommerce plugin elements.
		if ( FTC_WOO_ACTIVE ) {
			require_once FTC_CORE_DIR . 'widgets/ftc-product-categories.php';
			require_once FTC_CORE_DIR . 'widgets/ftc-products.php';
			require_once FTC_CORE_DIR . 'widgets/ftc-products-widget.php';
			require_once FTC_CORE_DIR . 'widgets/ftc-products-slider.php';
			require_once FTC_CORE_DIR . 'widgets/ftc-single-product.php';
			require_once FTC_CORE_DIR . 'widgets/ftc-products-tabs-slider.php';
			require_once FTC_CORE_DIR . 'widgets/ftc-list-products-by-category.php';
		}
		// Contact Form 7 plugin element.
		if ( FTC_ELEMENTS_CF7_ON ) {
			require_once FTC_CORE_DIR . 'widgets/ftc-contact-form-7.php';
		}
		// MailChimp 4 WP plugin element.
		if ( FTC_ELEMENTS_MC4WP_ON ) {
			require_once FTC_CORE_DIR . 'widgets/ftc-mailchimp.php';
		}

		// Instagram element.
		require_once FTC_CORE_DIR . 'widgets/ftc-instagram.php';
		require_once FTC_CORE_DIR . 'widgets/ftc-gallery-instagram.php';

		// slider.
		require_once FTC_CORE_DIR . 'widgets/ftc-all-slider.php';
		
		require_once FTC_CORE_DIR . 'widgets/ftc-menu-nav.php';

	}

	/**
	 * Custom controls for section
	 *
	 * @param  object $element - element type.
	 * @param  integer $section_id - id of section element.
	 * @param  array $args - section argumets.
	 * @return void
	 */
	public function custom_section_controls( $element, $section_id, $args ) {

		if ( 'section' === $element->get_name() && 'section_typo' === $section_id ) {

			$element->start_controls_section(
				'ftc_elements_section_sticky',
				[
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
					'label' => __( 'Sticky section', 'themeftc-core' ),
				]
			);

			$element->add_control(
				'ftc_elements_sticky',
				[
					'label'        => __( 'Section sticky method', 'themeftc-core' ),
					'type'         => \Elementor\Controls_Manager::SELECT,
					'default'      => 'not-sticked',
					'options'      => array(
						'not-sticked'    => __( 'Not sticked', 'themeftc-core' ),
						'sticked-header' => __( 'Sticked header', 'themeftc-core' ),
						'sticked-inner'  => __( 'Sticked inside column', 'themeftc-core' ),
						'sticked-footer' => __( 'Sticked footer', 'themeftc-core' ),
					),
					'prefix_class' => 'selection-is-',
				]
			);

			$element->end_controls_section();
		}
	}

	public function register_controls() {

		require FTC_CORE_DIR . '/includes/core/class-ftc-control.php';

		$controls_manager = \Elementor\Plugin::$instance->controls_manager;
		$controls_manager->register_control( 'sorter_label', new FTC_Control_Sorter() );
	}

	/**
	 * Plugin file inclusions (requirements)
	 *
	 * @return void
	 */
	public function includes() {

		require FTC_CORE_DIR . '/includes/Parsedown.php';
		require FTC_CORE_DIR . '/includes/admin.php';
		require FTC_CORE_DIR . '/includes/ajax_posts.php';
		require FTC_CORE_DIR . '/includes/ajax_load_product.php';
		require FTC_CORE_DIR . '/includes/inc/hook.php';
		require FTC_CORE_DIR . '/includes/inc/main-functions.php';
		require FTC_CORE_DIR . '/includes/instagram.php';
		require FTC_CORE_DIR . '/includes/class-menu-nav.php';

	}

	/**
	 * Load Plugin Text Domain
	 *
	 * @return false
	 * Looks for the plugin translation files in certain directories and loads
	 * them to allow the plugin to be localised
	 */
	public function load_plugin_textdomain() {

		$lang_dir = apply_filters( 'ftc_elements_lang_dir', trailingslashit( FTC_CORE_DIR . 'languages' ) );

		// Traditional WordPress plugin locale filter.
		$locale = apply_filters( 'plugin_locale', get_locale(), 'themeftc-core' );
		$mofile = sprintf( '%1$s-%2$s.mo', 'themeftc-core', $locale );

		// Setup paths to current locale file.
		$mofile_local = $lang_dir . $mofile;

		if ( file_exists( $mofile_local ) ) {
			// Look in the /wp-content/plugins/themeftc-for-elements/languages/ folder.
			load_textdomain( 'themeftc-core', $mofile_local );
		} else {
			// Load the default language files.
			load_plugin_textdomain( 'themeftc-core', false, $lang_dir );
		}

		return false;
	}

	/**
	 * Enqueue plugin styles
	 *
	 * @return void
	 */
	public function ftc_elements_styles() {

		// CSS styles.
		global $smof_data;
		wp_register_style( 'themeftc-core', FTC_CORE_URL . 'assets/css/default.css', array(), FTC_CORE_VERSION );
		wp_enqueue_style( 'themeftc-core' );
		wp_register_style( 'ftc-element-default', FTC_CORE_URL . 'assets/css/style_default.css', array(), FTC_CORE_VERSION );
		wp_enqueue_style( 'ftc-element-default' );

		// css page element
		wp_register_style( 'ftc-element-food', FTC_CORE_URL . 'assets/css/style_food.css', array(), FTC_CORE_VERSION );
		wp_enqueue_style( 'ftc-element-food' );

		wp_register_style( 'ftc-element-responsive-food', FTC_CORE_URL . 'assets/css/responsive/responsive_food.css', array(), FTC_CORE_VERSION );
		wp_enqueue_style( 'ftc-element-responsive-food' );


		$topic = '';
		if(isset($smof_data['ftc_style_for_elementor'])){
			$topic = $smof_data['ftc_style_for_elementor'] ;


			wp_register_style( 'ftc-element-'.$topic, FTC_CORE_URL . 'assets/css/'.$topic.'.css', array(), FTC_CORE_VERSION );
			wp_enqueue_style( 'ftc-element-'.$topic );

			wp_register_style( 'ftc-element-responsive'.$topic, FTC_CORE_URL . 'assets/css/responsive/responsive-'.$topic.'.css', array(), FTC_CORE_VERSION );
			wp_enqueue_style( 'ftc-element-responsive'.$topic );

			add_filter( 'body_class', function( $classes, $topic = 'jewelry' ) {
				global $smof_data;
				$topic = '';
				if(isset($smof_data['ftc_style_for_elementor'])){
					$topic = $smof_data['ftc_style_for_elementor'] ;
				}
				return array_merge( $classes, array($topic) );
			} );
		}
	}

	/**
	 * Enqueue plugin JS scrips
	 *
	 * @return void
	 */
	public function ftc_elements_scripts() {
		wp_enqueue_script('countdown-timer-script', FTC_CORE_URL . 'assets/js/jquery.countdown.js', array(), '1.0.0', true);
		wp_enqueue_script('countdown-circle', FTC_CORE_URL . 'assets/js/TimeCircles.js', array(), '1.0.0', true);
		wp_enqueue_script( 'countdown-circle', FTC_CORE_URL . 'assets/js/TimeCircles.js', array( 'jQuery' ), FTC_CORE_VERSION, true );
		// Register and enqueue plugin JS scripts.
		wp_register_script( 'ftc-elements-js', FTC_CORE_URL . 'assets/js/main-elements.min.js', '', FTC_CORE_VERSION, true );
		wp_enqueue_script( 'ftc-elements-js', FTC_CORE_URL . 'assets/js/main-elements.min.js', array( 'jQuery' ), FTC_CORE_VERSION, true );
		wp_enqueue_script( 'carousel', FTC_CORE_URL . 'assets/js/owl.carousel.min.js', '' , FTC_CORE_VERSION, true );
		wp_enqueue_script( 'carousel', FTC_CORE_URL . 'assets/js/owl.carousel.min.js', array( 'jQuery' ), FTC_CORE_VERSION, true );
		wp_enqueue_script( 'carousel' );
		wp_enqueue_script( 'ftcs-js', FTC_CORE_URL . 'assets/js/frontend.js','' , FTC_CORE_VERSION, true );
		wp_enqueue_script( 'ftcs-js', FTC_CORE_URL . 'assets/js/frontend.js', array( 'jQuery' ), FTC_CORE_VERSION, true );
		wp_enqueue_script( 'ftcs-js' );
		wp_enqueue_script('ftc-swiperr', FTC_CORE_URL . 'assets/js/swiper.min.js', array(), 'null', true);
		

		// Smartmenus scripts - postponed until v.1.0.0
		//wp_register_script( 'smartmenus', FTC_CORE_URL . 'assets/js/jquery.smartmenus.min.js' );

		$ajaxurl = '';
		if ( FTC_ELEMENTS_WPML_ON ) {
			$ajaxurl .= admin_url( 'admin-ajax.php?lang=' . ICL_LANGUAGE_CODE );
		} else {
			$ajaxurl .= admin_url( 'admin-ajax.php' );
		}

		wp_localize_script( 'ftc-elements-js', 'ftcLoadjs', array(
			'ajaxurl'      => esc_url( $ajaxurl ),
			'loadingposts' => esc_html__( 'Loading ...', 'themeftc-core' ),
			'noposts'      => esc_html__( 'No more found', 'themeftc-core' ),
			'loadmore'     => esc_html__( 'Load more', 'themeftc-core' ),
		) );

	}

	/**
	 * Enqueue editor scritps
	 *
	 * @return void
	 */
	public function editor_scripts() {

		wp_enqueue_script(
			'ftc-elements-editor',
			FTC_CORE_URL . 'assets/js/editor.js',
			[
				'elementor-editor', // dependency.
			],
			'',
			true // in_footer
		);
		wp_enqueue_script(
			'ftc-elements-car',
			FTC_CORE_URL . 'assets/js/owl.carousel.min.js',
			[
				'elementor-editor', // dependency.
			],
			'',
			true // in_footer
		);

	}


	/**
	 * Admin notice for plugin activation
	 *
	 * @return void
	 */
	public function admin_notice() {

		$class   = 'error updated settings-error notice is-dismissible';
		$message = __( '"The ThemeFTC Core plugin needs to activate the Elementor plugin to work, let the Elementor plugin use it".', 'themeftc-core' );
		echo '<div class="' . esc_attr( $class ) . '"><p>' . esc_html( $message ) . '</p></div>';

	}


} // end 

FTC_Elements::get_instance()->init();
