<?php
/**
 * Register the GitHub Gist shortcode
 */

function ftc_instagram_assets() {
	// Scripts.
	wp_enqueue_script(
		'ftc-instagram-block-js', // Handle.
		plugins_url( 'instagram-block/blocks.build.js', dirname( __FILE__ ) ), // Block.build.js: We register the block here. Built with Webpack.
		array( 'wp-blocks', 'wp-i18n', 'wp-element', 'wp-components', 'wp-editor' ), // Dependencies, defined above.
		// filemtime( plugin_dir_path( __DIR__ ) . 'dist/blocks.build.js' ), // Version: filemtime — Gets file modification time.
		false // Enqueue the script in the footer.
	);

	// Styles.
	wp_enqueue_style(
		'ftc-instagram-block-editor-css', // Handle.
		plugins_url( 'instagram-block/blocks.editor.build.css', dirname( __FILE__ ) ), // Block editor CSS.
		array( 'wp-edit-blocks' ) // Dependency to include the CSS after it.
		// filemtime( plugin_dir_path( __DIR__ ) . 'dist/blocks.editor.build.css' ) // Version: filemtime — Gets file modification time.
	);
} // End function ftc_guten_cgb_editor_assets().

// Hook: Editor assets.
add_action( 'enqueue_block_editor_assets', 'ftc_instagram_assets' );

function ftc_init() {
	global $pagenow;
	if ( 'post.php' === $pagenow || 'post-new.php' == $pagenow ) {
		wp_enqueue_script( 'ftc-instagram-feed-gallery-widget', plugins_url( 'instagram-block/ftc-instagram-feed-gallery-widget-public.js', dirname( __FILE__ ) ), array( 'jquery' ), '1.5', false );
	}
}
add_action( 'init', 'ftc_init' );

// Hook the post rendering to the block
if ( function_exists( 'register_block_type' ) ) :
	register_block_type(
		'social-gallery-block/social-gallery-block',
		array(
			'attributes'      => array(
				'photos_number' => array(
					'type'    => 'number',
					'default' => '6',
				),
				'size'   => array(
					'type'    => 'string',
					'default' => 'standard_resolution',
				),
			),
			'render_callback' => 'ftc_instagram_block_render_shortcode',
		)
	);
endif;

if ( class_exists( 'Ftc_Instagram_Feed_Gallery_Widget_Helper' ) ) {
	add_shortcode( 'ftc-instagram-block', 'ftc_instagram_block_render_shortcode' );
	function ftc_instagram_block_render_shortcode( $atts ) {
		$options              = ftc_instagram_feed_gallery_widget_get_options();
		$instance['photos_number']   = $atts['photos_number'];
		$instance['block']    = true;
		$instance['username'] = $options['username'];
		if ( is_admin() ) {
			$instance['admin'] = true;
		}

		$ftc_instagram_feed_gallery_widget_helper = new Ftc_Instagram_Feed_Gallery_Widget_Helper();
		return $ftc_instagram_feed_gallery_widget_helper->display( $instance );
	}
}
