<?php
/**
 * The Gallery and Widget for Instagram Shortcode for the plugin.
 *
 
 * @since      1.0.0
 *
 * @package    Ftc_Instagram_Feed_Gallery_Widget
 * @subpackage Ftc_Instagram_Feed_Gallery_Widget/includes
 */

/**
 * The Gallery and Widget for Instagram Shortcode for the plugin.
 *
 * @package    Ftc_Instagram_Feed_Gallery_Widget
 * @subpackage Ftc_Instagram_Feed_Gallery_Widget/includes
 *
 */
class Ftc_Instagram_Feed_Gallery_Widget_Shortcode {

	/**
	 * Our Gallery and Widget for Instagram shortcode.
	 * Constructor function
	 */
	function __construct() {
		add_shortcode( 'ftc-instagram-feed-gallery-widget', array( $this, 'ftc_instagram_feed_gallery_widget_shortcode' ) );
	}

	/**
	 * Our Gallery and Widget for Instagram shortcode.
	 * Prints Featured Content data styled to look good on *any* theme.
	 *
	 * @param  array $atts Widget attributes.
	 */
	static function ftc_instagram_feed_gallery_widget_shortcode( $atts ) {
		// Default attributes.
		$atts = shortcode_atts(
			array(
				'title'     => esc_html__( '', 'ftc-instagram-feed-gallery-widget' ),
				'username'  => '',
				'type'      => 'users',
				'layout'    => 'default',
				'padding'   => 0,
				'columns'    => 'six-columns',
				'photos_number'    => 6,
				'size'      => 'standard_resolution',
				'target'    => 0,
				'link_type' => 'link_site',
				'link_text' => esc_html__( 'View on Instagram', 'ftc-instagram-feed-gallery-widget' ),
				'element'   => 'shortcode',
				'is_slider' => 0,
				'auto_play' => 0,
				'show_nav'  => 0,
				'photo_space' => 10
			),
			$atts,
			'ftc-instagram-feed-gallery-widget'
		);

		$options = ftc_instagram_feed_gallery_widget_get_options();

		// A little sanitization.
		$atts['title'] = sanitize_text_field( $atts['title'] );

		$atts['username'] = isset( $options['username'] ) ? $options['username'] : '';

		$atts['columns'] = sanitize_key( $atts['columns'] );

		$atts['photos_number'] = ftc_instagram_feed_gallery_widget_sanitize_number_range( $atts['photos_number'] );

		$atts['size'] = sanitize_key( $atts['size'] );

		$atts['link_text'] = sanitize_text_field( $atts['link_text'] );

		$atts['element'] = 'shortcode';
		$atts['is_slider'] = sanitize_key($atts['is_slider']);
		$atts['auto_play'] = sanitize_key($atts['auto_play']);
		$atts['show_nav'] = sanitize_key($atts['show_nav']);
		$atts['photo_space'] = sanitize_key($atts['photo_space']);

		$ftc_instagram_feed_gallery_widget_helper = new Ftc_Instagram_Feed_Gallery_Widget_Helper();
		return $ftc_instagram_feed_gallery_widget_helper->display( $atts );
	}
}

/**
 * Function run_ftc_instagram_feed_gallery_widget_shortcode.
 */
function run_ftc_instagram_feed_gallery_widget_shortcode() {
	$shortcode = new Ftc_Instagram_Feed_Gallery_Widget_Shortcode();
}
run_ftc_instagram_feed_gallery_widget_shortcode();
