<?php
/**
 * Adds Social Gallery and Widget button to TinyMCE editor
 *
 
 * @since      1.0.0
 *
 * @package    Ftc_Instagram_Feed_Gallery_Widget
 * @subpackage Ftc_Instagram_Feed_Gallery_Widget/includes
 */

/**
 * The Social Gallery and Widget button to TinyMCE editor
 *
 * @package    Ftc_Instagram_Feed_Gallery_Widget
 * @subpackage Ftc_Instagram_Feed_Gallery_Widget/includes
 */
class Ftc_Instagram_Feed_Gallery_Widget_Add_Editor_Button {

	/**
	 * Sets up thickbox and button
	 */
	public function __construct() {
		add_action( 'admin_footer', array( $this, 'thickbox_display' ) );
		add_action( 'media_buttons', array( $this, 'add_editor_button' ), 15 );
	}

	/**
	 * Add button to editor
	 */
	public function add_editor_button() {
		global $pagenow;

		$page_post_array = array( 'post-new.php', 'post.php' );

		// Only run in post/page creation and edit screens.
		if ( ! in_array( $pagenow, $page_post_array, true ) ) {
			return;
		}
		add_thickbox();
		echo '
	    <style>
	        #add-ftc-instagram-feed-gallery-widget-shortcode:before {
	            vertical-align: middle;
	        }
	    </style>
	    <a href="#TB_inline?&inlineId=display-ftc-instagram-feed-gallery-widget-shortcode&width=753&height=auto" id="add-ftc-instagram-feed-gallery-widget-shortcode" class="thickbox button" title="' .
				esc_attr__( 'Add Social Gallery & Widget Shortcodes', 'ftc-instagram-feed-gallery-widget' ) . '"><img src="' . esc_url( plugin_dir_url( __FILE__ ) . '../admin/images/icon.svg' ) . '" /></a>';
	}

	/**
	 * Adds Thickbox content to admin footer on page/post add and edit pages(includes CPT)
	 */
	public function thickbox_display() {
		?>
		<script type="text/javascript">
			jQuery(document).ready(function($){
				var prev_code;
				if( undefined !== $('div#wp-content-editor-container textarea').val() ) {
					prev_code = $('div#wp-content-editor-container textarea').val().match(/\[(ftc-instagram-feed-gallery-widget.*)\]/);
				}

				if ( undefined !== $('div#wp-content-editor-container textarea').val() ) {
					code = $('div#wp-content-editor-container textarea').val().match(/\[(ftc-instagram-feed-gallery-widget.*)\]/);
					if( null != code ) {
						$('#ftc_instargarm_insert_shortcode').html('Update Shortcode');
						shortcode = '<' + code[1] + '>';
						$(shortcode).each(function() {
							$.each(this.attributes, function(){
								// this.attributes is not a plain object, but an array
								// of attribute nodes, which contain both the name and value
								// Getting previous values
								// Type Select
								if ( 'size' === this.name ) {
									$('#ftc_instagram_feed_gallery_widget_shortcode_size option[value='+this.value+']').attr('selected','selected');
								}
								// Type Text
								else {
									$("input[name='"+this.name+"'").val(this.value);
								}
							});
						});
					}
				}
				$('#ftc-instagram-feed-gallery-widget-shortcode-form').on('submit', function(e){
					if( undefined !== $('div#wp-content-editor-container textarea').val() ) {
						prev_code = $('div#wp-content-editor-container textarea').val().match(/\[(ftc-instagram-feed-gallery-widget.*)\]/);
					}
					e.preventDefault();
					var submit = true;
					var shortcode = '';
					var values = $('#ftc-instagram-feed-gallery-widget-shortcode-wrapper :input');
					var content_type;
					$.each(values, function(k,v){
						if( 'checkbox' == v.type ) {
							shortcode += ' ' + v.name + '=' + '"' + v.checked + '"';
						}
						else {
							if ( 'username' == v.name ) {
								// Do nothing by default it shows self's instagram feed
							}else if( 'title' === v.name ) {
								if( '' ==! v.value ) {
									shortcode += v.name + '=' + '"' + v.value + '" ';
								}else {
									shortcode += v.name + '="" ';
								}
							}else {
								if ( '' !== v.value ) {
									shortcode += ' ' + v.name + '=' + '"' + v.value + '"';
								}
							}
						}
					});
					if ( '' != shortcode && submit ) {
						shortcode = '[ftc-instagram-feed-gallery-widget ' + shortcode + ']';
						if( undefined !== $('div#wp-content-editor-container textarea').val() && null != prev_code ) {

							if(!tinyMCE.activeEditor)jQuery('.wp-editor-wrap .switch-tmce').trigger('click');

							var content = tinyMCE.activeEditor.getContent();


							var new_content = content.replace(prev_code[0], '');

							tinyMCE.activeEditor.setContent(new_content);
							//tinymce.activeEditor.execCommand('mceInsertContent', false, new_content);
						}
						//return false;
						window.send_to_editor( shortcode );
						tb_remove();
					}
					else {
						return false;
					}
				});

			});
		</script>

		<div id="display-ftc-instagram-feed-gallery-widget-shortcode" style="display: none;">
			<form id="ftc-instagram-feed-gallery-widget-shortcode-form">
			<div id="ftc-instagram-feed-gallery-widget-shortcode-wrapper" class="ftc-instagram-feed-gallery-widget-shortcode-wrapper" style="margin: 0 auto; width: 500px;">
				<?php $options = ftc_instagram_feed_gallery_widget_get_options( 'ftc_instagram_feed_gallery_widget_options' ); ?>

				<p>
					<label for="ftc_instagram_feed_gallery_widget_shortcode_title"><?php esc_html_e( 'Title', 'ftc-instagram-feed-gallery-widget' ); ?>:</label>
					<input type="text" id="ftc_instagram_feed_gallery_widget_shortcode_title" name="title" class="widefat ftc-instagram-feed-gallery-widget-title" value="Social Gallery and Widget" />
				</p>

				<p>
					<label for="ftc_instagram_feed_gallery_widget_shortcode_username"><?php esc_html_e( 'Instagram Username', 'ftc-instagram-feed-gallery-widget' ); ?>:</label>
					<input type="text" id="ftc_instagram_feed_gallery_widget_shortcode_username" name="username" class="widefat ftc-instagram-feed-gallery-widget-username" value="<?php echo $options['username']; ?>" disabled="disabled" />
				</p>
				<span class="show-more button"><?php esc_html_e( 'More Options', 'ftc-instagram-feed-gallery-widget' ); ?><i class="dashicons dashicons-arrow-down"></i></span>
				<div class="more-options">

				<p>
					<label for="ftc_instagram_feed_gallery_widget_shortcode_number"><?php esc_html_e( 'Number of items', 'ftc-instagram-feed-gallery-widget' ); ?>:</label>
					<input type="number" id="ftc_instagram_feed_gallery_widget_shortcode_number" name="number" class="small-text ftc-instagram-feed-gallery-widget-number" max="30" min="1" value="6" />
				</p>
				<p class="description"><?php esc_html_e( 'Max is 30.', 'ftc-instagram-feed-gallery-widget' ); ?></p>

				</div>
			</div>
			<p style="margin: 0 auto; width: 500px;">
				<button id="ftc_instargarm_insert_shortcode" class="button button-primary button-large"><?php esc_html_e( 'Insert Shortcode', 'ftc-instagram-feed-gallery-widget' ); ?></button>
			</p>
			</form>
		</div>
		<?php
	}
}

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_add_ftc_instagram_feed_gallery_widget_editor_button_extension() {
	$ftc_instagram_feed_gallery_widget_add_editor_button = new Ftc_Instagram_Feed_Gallery_Widget_Add_Editor_Button;
}
run_add_ftc_instagram_feed_gallery_widget_editor_button_extension();
