<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 
 * @since      1.0.0
 *
 * @package    Ftc_Instagram_Feed_Gallery_Widget
 * @subpackage Ftc_Instagram_Feed_Gallery_Widget/admin/partials
 */

?>
<?php
	$username                                 = '';
	$ftc_instagram_feed_gallery_widget_page = admin_url( 'options-general.php?page=ftc-instagrams-widget' );

	$options = ftc_instagram_feed_gallery_widget_get_options();

if ( '' !== $options['access_token'] ) {
	$time = $options['expires_in'];
	$now  = time();

	// Calculate remaining time for instagram's token expiration.
	$remaining = $now - $time;

	// Refresh access token when 7 days expiration time is remaining.
	if ( $remaining > -604800 ) {

		$re_data = Ftc_Instagram_Feed_Gallery_Widget_Admin::refresh_access_token();

	}
}
?>
<div class="wrap">
	<div class="catchp-content-wrapper">
		<div class="catchp_widget_settings">
			<form id="ftc-instagram-feed-gallery-widget-main" method="post" action="options.php">

				<h2 class="nav-tab-wrapper">
					<a class="nav-tab nav-tab-active" id="dashboard-tab" href="#dashboard"><?php esc_html_e( 'Dashboard', 'ftc-instagram-feed-gallery-widget' ); ?></a>
					<a class="nav-tab" id="features-tab" href="#features"><?php esc_html_e( 'Features', 'ftc-instagram-feed-gallery-widget' ); ?></a>
					<a class="nav-tab" id="premium-extensions-tab" href="#premium-extensions"><?php esc_html_e( 'Compare Table', 'ftc-instagram-feed-gallery-widget' ); ?></a>
				</h2>

				<div id="dashboard" class="wpcatchtab  nosave active">

					<div id="public-usage" class="content-wrapper">
					</div><!-- #public-usage.content-wrapper -->


					<?php
					settings_fields( 'ftc-instagram-feed-gallery-widget-group' );
					$ftc_instagram_feed_gallery_widget_options = ftc_instagram_feed_gallery_widget_get_options();
					if ( isset( $_GET['access_token'] ) ) {
						$access_token = sanitize_text_field( wp_unslash( $_GET['access_token'] ) );
					} elseif ( isset( $ftc_instagram_feed_gallery_widget_options['access_token'] ) && ( '' !== $ftc_instagram_feed_gallery_widget_options['access_token'] ) ) {
						$access_token = $ftc_instagram_feed_gallery_widget_options['access_token'];
					} else {
						$access_token = '';
					}
					?>

					<?php
					if ( isset( $access_token ) && '' !== $access_token ) {
						$re_data = Ftc_Instagram_Feed_Gallery_Widget_Admin::update_data( $access_token );
					}

					if ( isset( $ftc_instagram_feed_gallery_widget_options['username'] ) && ! empty( $ftc_instagram_feed_gallery_widget_options['username'] ) ) {
						$username = $ftc_instagram_feed_gallery_widget_options['username'];
					}

					if ( isset( $_GET['q'] ) && 'logout' === $_GET['q'] ) {
						if ( delete_option( 'ftc_instagram_feed_gallery_widget_options' ) ) {
							delete_transient( 'ftc_insta_json' );
							$re_data['message'] = esc_html__( 'Options reset successfully.', 'ftc-instagram-feed-gallery-widget' );
							$re_data['type']    = 'notice-success';
						} else {
							$re_data['message'] = esc_html__( 'Reset failed, please try again', 'ftc-instagram-feed-gallery-widget' );
							$re_data['type']    = 'notice-error';
						}
					}
					?>

					<div id="access-token" class="content-wrapper">
						<div class="header">
							<h2 style="background: #333;color: #fff;">Instagram Settings</h2>
							<h2><?php esc_html_e( 'Authorize with Instagram', 'ftc-instagram-feed-gallery-widget' ); ?></h2>

						</div><!-- .header -->
						<div class="content">
							<?php
							$options      = get_option( 'ftc_instagram_feed_gallery_widget_options' );
							$username     = isset( $options['username'] ) ? $options['username'] : '';
							$user_id      = isset( $options['user_id'] ) ? $options['user_id'] : '';
							$access_token = isset( $options['access_token'] ) ? $options['access_token'] : '';
							if ( $username && $access_token ) :
								?>
								<p><?php esc_html_e( 'You are logged in: ', 'ftc-instagram-feed-gallery-widget' ); ?> <strong><?php echo esc_html( $username ); ?></strong></p>
								<p class="info-authentication">
									<strong><?php esc_html_e( 'Access token: ', 'ftc-instagram-feed-gallery-widget' ); ?></strong>
									<input class="dont-break-out" value="<?php echo esc_html( $access_token ); ?>"></input>
								</p>
								<p class="info-authentication">
									<strong><?php esc_html_e( 'User ID: ', 'ftc-instagram-feed-gallery-widget' ); ?></strong>
									<strong class="dont-break-out"><?php echo esc_html( $user_id  ); ?></strong>
								</p>
							<?php endif; ?>
							<?php if ( '' === $username || '' === $access_token ) : ?>
								<a class="button button-large get-token" href="https://api.instagram.com/oauth/authorize/?client_id=591128381467111
								&scope=user_profile,user_media
								&redirect_uri=https://catchplugins.com/social-gallery-widget-personal?return_url=<?php echo esc_attr( $ftc_instagram_feed_gallery_widget_page ); ?>
								&response_type=code
								&state=<?php echo esc_url( $ftc_instagram_feed_gallery_widget_page ); ?>"><?php esc_html_e( 'Authorize with Instagram', 'ftc-instagram-feed-gallery-widget' ); ?></a>

							<?php else : ?>

								<input type="hidden" name="ftc-instagram-reset-nonce" id="ftc-instagram-reset-nonce" value="<?php echo esc_attr( wp_create_nonce( 'ftc-instagram-reset-nonce' ) ); ?>" />
								<a class="button button-large reset-token cifgw-instagram-logout" id="ftc-instagram-feed-gallery-widget-reset" href="<?php echo esc_attr( $ftc_instagram_feed_gallery_widget_page ) . '&q=logout'; ?>"><?php esc_html_e( 'Logout', 'ftc-instagram-feed-gallery-widget-pro' ); ?></a>

							<?php endif; ?>
							<?php if ( isset( $_GET['q'] ) || isset( $_GET['access_token'] ) ) : ?>
								<div class="notice <?php echo isset( $re_data['type'] ) ? esc_attr( $re_data['type'] ) : ''; ?>">
									<p><?php echo isset( $re_data['message'] ) ? esc_html( $re_data['message'] ) : ''; ?></p>
								</div>
							<?php endif; ?>
						</div><!-- .content -->
					</div><!-- #access-token.content-wrapper -->
					<div id="ctp-switch" class="content-wrapper col-3 ftc-instagram-feed-gallery-widget-main">
					</div><!-- #ctp-switch -->

					<div id="go-premium" class="content-wrapper col-2">
					</div> <!-- #go-premium -->

					<div id="pro-screenshot" class="content-wrapper col-4">
					</div> <!-- #pro-screenshot -->
				</div><!-- .dashboard -->

			</form><!-- #ftc-instagram-feed-gallery-widget-main -->

		</div>

	</div>
</div><!-- .wrap -->
